// FUNZIONI PULSANTI SEGNI NEGATIVI POSITIVI 

// Funzione pulsante AC/DC
function annosegno(obj)  
	{  
		if (obj.ANNO_SEGNO.value == "DC")
    		{
				obj.ANNO_SEGNO.value = "AC";
				obj.anno.value = obj.anno.value * -1;	
			}
    	else
  			{
				obj.ANNO_SEGNO.value = "DC";
				obj.anno.value = obj.anno.value * -1;
			}
	}

// Funzione pulsante Latitudine N/S 
function latsegno(obj)  
	{  
		if (obj.LAT_SEGNO.value == "Nord")
    		{
				obj.LAT_SEGNO.value = "Sud";
				obj.lat_G.value = obj.lat_G.value * -1;
				obj.lat_M.value = obj.lat_M.value * -1;
				obj.lat_S.value = obj.lat_S.value * -1;
			}
    	else
  			{
				obj.LAT_SEGNO.value = "Nord";
				obj.lat_G.value = obj.lat_G.value * -1;
				obj.lat_M.value = obj.lat_M.value * -1;
				obj.lat_S.value = obj.lat_S.value * -1;
			}
	}

// Funzione pulsante Longitudine E/O 
function longsegno(obj)  
	{  
		if (obj.LONG_SEGNO.value == "Est")
    		{
				obj.LONG_SEGNO.value = "Ovest";
				obj.long_G.value = obj.long_G.value * -1;
				obj.long_M.value = obj.long_M.value * -1;
				obj.long_S.value = obj.long_S.value * -1;
			}
    	else
  			{
				obj.LONG_SEGNO.value = "Est";
				obj.long_G.value = obj.long_G.value * -1;
				obj.long_M.value = obj.long_M.value * -1;
				obj.long_S.value = obj.long_S.value * -1;
			}
	}

// Funzione pulsante Converti l'azimut dello strumento 
function calc_teo_1(obj)  
	{  
		obj.ar_teo.value = eval(obj.ar_teo.value); 				
		ar1_dec = obj.ar_teo.value * (360/400); 
		
		azim_G = Math.floor(ar1_dec);		
		azim_M_dec = (ar1_dec - azim_G) * 60;
		azim_M = Math.floor(azim_M_dec) ;
		azim_S = (azim_M_dec - azim_M) * 60 ;
		
		obj.ar1_g.value = azim_G;
		obj.ar1_p.value = azim_M;
		obj.ar1_s.value = azim_S.toFixed(0); 		
	}


// Funzione segno dell'azimut convertito o rilevato 
function az1segno(obj)  
	{  
		if (obj.AZ1_SEGNO.value == "+")
    		{
				obj.AZ1_SEGNO.value = "-";
				obj.ar1_g.value = obj.ar1_g.value * -1;
				obj.ar1_p.value = obj.ar1_p.value * -1;
				obj.ar1_s.value = obj.ar1_s.value * -1;
			}
    	else
  			{
				obj.AZ1_SEGNO.value = "+";
				obj.ar1_g.value = obj.ar1_g.value * -1;
				obj.ar1_p.value = obj.ar1_p.value * -1;
				obj.ar1_s.value = obj.ar1_s.value * -1;
			}
	}
	
	
// Funzione pulsante Rifrazione
function rifr(obj)  
{
			  ho_g = myParseFloat(obj.ho_g.value);
			  if (ho_g >= 90 | ho_g < 0)
				  {
					  alert("\n GRADI ALTEZZA OSSERVATA ERRATI: \n\n DATI VALIDI DA 0 A 89 \n\n CLICCA SU RESET E RIPROVA"); 
				  }
			  ho_p = myParseFloat(obj.ho_p.value);
			  if (ho_p >= 60 | ho_p <0)
				  {
					  alert("\n PRIMI ALTEZZA OSSERVATA ERRATI: \n\n DATI VALIDI DA 0 A 59 \n\n CLICCA SU RESET E RIPROVA"); 
				  }
			  ho_s = myParseFloat(obj.ho_s.value);
			  if (ho_s >= 60 | ho_s <0)
				  {
					  alert("\n SECONDI ALTEZZA OSSERVATA ERRATI: \n\n DATI VALIDI DA 0 A 59 \n\n CLICCA SU RESET E RIPROVA"); 
				  }
	
			pressione = myParseFloat(obj.pressione.value); 
			if (pressione >=1300 | pressione <= 300)
				{
					alert("\n DATO PRESSIONE INSERITO ANOMALO \n\n CLICCA SU RESET E RIPROVA"); 
				}	
			
			temperatura = myParseFloat(obj.temperatura.value); 
			if (temperatura >=100 | temperatura <= -50)
				{
					alert("\n DATO TEMPERATURA INSERITO ANOMALO \n\n CLICCA SU RESET E RIPROVA"); 
				}	
	
			// Inizio del calcolo ----------------------------------------------------------------
			ho_dec = ho_s / 3600 + ho_p /60 + ho_g;
		
			// Calcolo della rifrazione 
			rifrazione = 1 / Math.tan((ho_dec + 7.31/(ho_dec + 4.4))*Math.PI/180);
			
			c = ((pressione / 1010) * (283 / (273 + temperatura)));
			
			rifrazione_corretta = rifrazione * c;
			
			rm_dec = rifrazione_corretta / 60;
						
			// Conversioni in gradi primi e secondi 			
			rm = Math.abs(rm_dec); 
			rm_g = Math.floor(rm);		
			rm_p_dec = (rm - rm_g) * 60;
			rm_p = Math.floor(rm_p_dec) ;
			rm_s = (rm_p_dec - rm_p) * 60 ;
			//rm_sgn = "+ ";
			//if (rm_dec < 0)
			//	{
			//		rm_sgn = "- ";
			//	}

			// Risultati 
			//obj.rm_dec.value = rm_dec;
		
			//obj.rm_sgn.value = rm_sgn;

			obj.rm_g.value = rm_g;
			obj.rm_p.value = rm_p;
			obj.rm_s.value = rm_s.toFixed(2);
	
}
	

// Funzione pulsante semidiametro del Sole 
function sdssegno(obj)  
	{  
		if (obj.SDS_SEGNO.value == "+ (Lembo Inferiore)")
    		{
				obj.SDS_SEGNO.value = "- (Lembo Superiore)";
				obj.sds_p.value = obj.sds_p.value * -1;
				obj.sds_s.value = obj.sds_s.value * -1;
			}
    	else
  			{
				obj.SDS_SEGNO.value = "+ (Lembo Inferiore)";
				obj.sds_p.value = obj.sds_p.value * -1;
				obj.sds_s.value = obj.sds_s.value * -1;
			}
	}

// Funzione pulsante semidiametro della luna 
function sdlsegno(obj)  
	{  
		if (obj.SDL_SEGNO.value == "+ (Lembo Inferiore)")
    		{
				obj.SDL_SEGNO.value = "- (Lembo Superiore)";
				obj.sdl_p.value = obj.sdl_p.value * -1;
				obj.sdl_s.value = obj.sdl_s.value * -1;
			}
    	else
  			{
				obj.SDL_SEGNO.value = "+ (Lembo Inferiore)";
				obj.sdl_p.value = obj.sdl_p.value * -1;
				obj.sdl_s.value = obj.sdl_s.value * -1;
			}
	}

// Funzione segno anno epoca 
function annoepsegno(obj)  
	{  
		if (obj.ANNO_EP_SEGNO.value == "DC")
    		{
				obj.ANNO_EP_SEGNO.value = "AC";
				obj.anno_ep.value = obj.anno_ep.value * -1;	
			}
    	else
  			{
				obj.ANNO_EP_SEGNO.value = "DC";
				obj.anno_ep.value = obj.anno_ep.value * -1;
			}
	}
